/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.retained;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SGIORuntimeException;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTable;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DanglingReferenceException;

public class StreamControl
extends Controller {
    protected String FILE_IDENT = new String("j3dsf");
    private DataInputStream inputStream;
    private DataOutputStream outputStream;

    public StreamControl(DataOutputStream dataOutputStream) {
        this.outputStream = dataOutputStream;
        this.symbolTable = new SymbolTable(this);
    }

    public StreamControl(DataInputStream dataInputStream) {
        this.inputStream = dataInputStream;
        this.symbolTable = new SymbolTable(this);
    }

    public void writeStreamHeader() throws IOException {
        this.outputStream.writeUTF(this.FILE_IDENT);
        this.outputStream.writeInt(this.outputFileVersion);
    }

    public void readStreamHeader() throws IOException {
        String string = this.inputStream.readUTF();
        if (string.equals("demo_j3s")) {
            throw new IOException("Use Java 3D Fly Through I/O instead of Java 3D Scenegraph I/O");
        }
        if (!string.equals("j3dsf")) {
            throw new IOException("This is a File - use SceneGraphFileReader instead");
        }
        this.currentFileVersion = this.inputStream.readInt();
        if (this.currentFileVersion > this.outputFileVersion) {
            throw new IOException("Unsupported file version. This file was written using a new version of the SceneGraph IO API, please update your installtion to the latest version");
        }
    }

    public void addNamedObjects(HashMap hashMap) {
        this.symbolTable.addNamedObjects(hashMap);
    }

    public void writeBranchGraph(BranchGroup branchGroup, Serializable serializable) throws IOException {
        try {
            SymbolTableData symbolTableData = this.symbolTable.getSymbol(branchGroup);
            if (symbolTableData == null) {
                symbolTableData = this.symbolTable.createSymbol(branchGroup);
                symbolTableData.branchGraphID = -1;
            }
            this.symbolTable.setBranchGraphRoot(symbolTableData, 0L);
            this.symbolTable.startUnsavedNodeComponentFrame();
            SceneGraphObjectState sceneGraphObjectState = this.createState(branchGroup, symbolTableData);
            this.writeObject(this.outputStream, sceneGraphObjectState);
            this.writeNodeComponents(this.outputStream);
            this.symbolTable.endUnsavedNodeComponentFrame();
            if (this.symbolTable.branchGraphHasDependencies(symbolTableData.branchGraphID)) {
                throw new DanglingReferenceException();
            }
            this.symbolTable.clearUnshared();
            this.symbolTable.writeTable(this.outputStream);
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
    }

    public BranchGroup readBranchGraph(HashMap hashMap) throws IOException {
        try {
            SceneGraphObjectState sceneGraphObjectState = this.readObject(this.inputStream);
            this.readNodeComponents(this.inputStream);
            this.symbolTable.readTable(this.inputStream, true);
            this.symbolTable.setBranchGraphRoot(sceneGraphObjectState.getSymbol(), 0L);
            sceneGraphObjectState.buildGraph();
            if (hashMap != null) {
                this.symbolTable.getNamedObjectMap(hashMap);
            }
            return (BranchGroup)sceneGraphObjectState.getNode();
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
    }

    protected void readBranchGraphs(int[] nArray) throws IOException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.readBranchGraph(null);
        }
    }

    public void loadNodeComponent(SymbolTableData symbolTableData) throws IOException {
        throw new IOException("Unable to load individual NodeComponents from Stream");
    }

    public void close() throws IOException {
        super.reset();
    }

    public long getFilePointer() {
        return 0L;
    }
}

